package dyte.io.uikit.view

import android.content.Context
import android.util.AttributeSet
import android.util.Log
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.designtokens.TokenRepoType
import io.dyte.core.DyteMobileClient
import io.dyte.core.controllers.GridInfo
import io.dyte.core.listeners.DyteParticipantEventsListener
import io.dyte.core.models.DyteRoomParticipants

class DyteParticipantCountView : LinearLayout {
  private lateinit var tvParticipantCount: DyteLabelAtom

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.participant_count, this)

    tvParticipantCount = findViewById(R.id.tvParticipantCount)
  }

  fun refresh(dyteAndroidClient: DyteMobileClient) {
    dyteAndroidClient.addParticipantEventsListener(object : DyteParticipantEventsListener {
      override fun onUpdate(participants: DyteRoomParticipants) {
        super.onUpdate(participants)
        if (participants.joined.isNotEmpty()) {
          tvParticipantCount.text = participants.joined.size.toString()
        }
      }
    })
  }
}