package dyte.io.uikit.view

import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.view.Gravity
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import dyte.io.uikit.R
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class DyteRecordingIndicator : LinearLayout {
  private lateinit var indicatorImageView: ImageView
  private lateinit var indicatorTextView: TextView

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int, defStyleRes: Int) : super(
    context,
    attrs,
    defStyleAttr,
    defStyleRes
  ) {
    init()
  }

  private fun init(uiTokens: DyteUITokens = tokens) {
    inflate(context, R.layout.view_dyte_recording_indicator, this)
    orientation = HORIZONTAL
    gravity = Gravity.CENTER

    indicatorImageView = findViewById(R.id.imageview_dyte_recording_indicator)
    indicatorTextView = findViewById(R.id.textview_dyte_recording_indicator)
    applyUiTokens(uiTokens)
  }

  fun applyUiTokens(uiTokens: DyteUITokens) {
    indicatorImageView.imageTintList = ColorStateList.valueOf(uiTokens.colors.status.danger)
    indicatorTextView.setTextColor(uiTokens.colors.status.danger)
  }
}