package dyte.io.uikit.view

import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.widget.LinearLayout
import android.widget.ProgressBar
import dyte.io.uikit.R
import dyte.io.uikit.tokens
import dyte.io.uikit.wiptoken.DyteUITokens

class FullScreenLoaderView: LinearLayout {
  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.full_screen_loader, this)
    setBackgroundColor(tokens.colors.background.shade1000)
    findViewById<ProgressBar>(R.id.pbLoader).indeterminateTintList = ColorStateList.valueOf(
      tokens.colors.brand.shade500
    )
  }
}