package dyte.io.uikit.view

import android.content.Context
import android.graphics.Paint
import android.graphics.Rect
import android.graphics.drawable.Drawable
import android.util.AttributeSet
import dyte.io.uikit.view.IconButton.DrawablePositions.LEFT
import dyte.io.uikit.view.IconButton.DrawablePositions.NONE
import dyte.io.uikit.view.IconButton.DrawablePositions.RIGHT

class IconButton : androidx.appcompat.widget.AppCompatButton {
  protected var drawableWidth = 0
  protected var drawablePosition: DrawablePositions? = null
  protected var iconPaddings: Int = 0

  // Cached to prevent allocation during onLayout
  var bounds: Rect

  enum class DrawablePositions {
    NONE,
    LEFT,
    RIGHT
  }

  constructor(context: Context) : super(context) {
    bounds = Rect()
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    bounds = Rect()
  }

  constructor(context: Context, attrs: AttributeSet?, defStyle: Int) : super(
    context,
    attrs,
    defStyle
  ) {
    bounds = Rect()
  }

  fun setIconPadding(padding: Int) {
    iconPaddings = padding
    requestLayout()
  }

  override fun onLayout(changed: Boolean, left: Int, top: Int, right: Int, bottom: Int) {
    super.onLayout(changed, left, top, right, bottom)
    val textPaint: Paint = paint
    val text = text.toString()
    textPaint.getTextBounds(text, 0, text.length, bounds)
    val textWidth = bounds.width()
    val contentWidth = drawableWidth + iconPaddings + textWidth
    val contentLeft = (width / 2.0 - contentWidth / 2.0).toInt()

    compoundDrawablePadding = -contentLeft + iconPaddings
    when (drawablePosition) {
      LEFT -> setPadding(contentLeft, 0, 0, 0)
      RIGHT -> setPadding(0, 0, contentLeft, 0)
      else -> setPadding(0, 0, 0, 0)
    }
  }

  override fun setCompoundDrawablesWithIntrinsicBounds(
    left: Drawable?,
    top: Drawable?,
    right: Drawable?,
    bottom: Drawable?
  ) {
    super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom)
    if (null != left) {
      drawableWidth = left.intrinsicWidth
      drawablePosition = LEFT
    } else if (null != right) {
      drawableWidth = right.intrinsicWidth
      drawablePosition = RIGHT
    } else {
      drawablePosition = NONE
    }
    requestLayout()
  }
}