package dyte.io.uikit.view

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.util.AttributeSet
import android.widget.ImageView
import android.widget.LinearLayout
import dyte.io.uikit.R
import dyte.io.uikit.atoms.DyteLabelAtom
import dyte.io.uikit.designtokens.TokenRepo
import dyte.io.uikit.utils.Utils.px
import io.dyte.core.feat.DyteMeetingParticipant

class ImageButton : LinearLayout {
  private lateinit var participant: DyteMeetingParticipant
  private lateinit var tvName: DyteLabelAtom
  private lateinit var ivMic: ImageView
  private lateinit var llNameTagView: LinearLayout
  val shape = GradientDrawable()

  constructor(context: Context) : super(context) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?
  ) : super(context, attrs) {
    init()
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(
    context,
    attrs,
    defStyleAttr
  ) {
    init()
  }

  private fun init() {
    inflate(context, R.layout.image_button_view, this)
    ivMic = findViewById(R.id.ivMic)
    tvName = findViewById(R.id.tvNameTag)
    llNameTagView = findViewById(R.id.llNameTagContainer)
    refresh()
  }

  fun refresh() {
    val tokenRepo = TokenRepo
    shape.cornerRadius = tokenRepo.getBorderRadiusRepo().getBorderRadius(2).px.toFloat()
    shape.setColor(tokenRepo.getColorRepo().getSettingViewBackground())
    llNameTagView.background = shape
    // tvName.refresh()
    tvName.setTextColor(tokenRepo.getColorRepo().getIconColor())
    tvName.text = "Test"
  }

  fun getPeerId() = participant.id
}