package dyte.io.uikit.wiptoken

import android.graphics.Color

class ColorTokens(
  var brand: BrandColor,
  var background: BackgroundColor,
  var text: TextColor,
  var status: StatusColor = StatusColor(),
  var videoBackground: Int = Color.parseColor("#333333")
)

class BrandColor(
  val shade300: Int,
  val shade400: Int,
  val shade500: Int,
  val shade600: Int,
  val shade700: Int
)

class BackgroundColor(
  val shade600: Int,
  val shade700: Int,
  val shade800: Int,
  val shade900: Int,
  val shade1000: Int
)

class StatusColor(
  val success: Int = Color.parseColor("#83D017"),
  val warning: Int = Color.parseColor("#FFCD07"),
  val danger: Int = Color.parseColor("#FF2D2D")
)

class TextColor(
  onBrand: TextColor.TextColorOnBrand,
  onBackground: TextColor.TextColorOnBackground
) {
  var onBrand: TextColorOnBrand = onBrand
    private set
  var onBackground: TextColorOnBackground = onBackground
    private set

  class TextColorOnBrand {
    val shade600: Int
    val shade700: Int
    val shade800: Int
    val shade900: Int
    val shade1000: Int

    // TODO: Implemented shade generation based on opacity
    constructor(baseColor: Int) {
      this.shade1000 = baseColor
      this.shade600 = Color.BLACK
      this.shade700 = Color.BLACK
      this.shade800 = Color.BLACK
      this.shade900 = Color.BLACK
    }

    constructor(shade600: Int, shade700: Int, shade800: Int, shade900: Int, shade1000: Int) {
      this.shade600 = shade600
      this.shade700 = shade700
      this.shade800 = shade800
      this.shade900 = shade900
      this.shade1000 = shade1000
    }
  }

  class TextColorOnBackground {
    val shade600: Int
    val shade700: Int
    val shade800: Int
    val shade900: Int
    val shade1000: Int

    // TODO: Implemented shade generation based on opacity
    constructor(baseColor: Int) {
      this.shade1000 = baseColor
      this.shade600 = Color.BLACK
      this.shade700 = Color.BLACK
      this.shade800 = Color.BLACK
      this.shade900 = Color.BLACK
    }

    constructor(shade600: Int, shade700: Int, shade800: Int, shade900: Int, shade1000: Int) {
      this.shade600 = shade600
      this.shade700 = shade700
      this.shade800 = shade800
      this.shade900 = shade900
      this.shade1000 = shade1000
    }
  }
}