/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.h2.api.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2HistoryTrigger
implements Trigger {
    private static final Logger log = LoggerFactory.getLogger(H2HistoryTrigger.class);
    private static final String SYS_PERIOD_START = "SYS_PERIOD_START";
    private static final String SYS_PERIOD_END = "SYS_PERIOD_END";
    private static final String HISTORY_SUFFIX = "_history";
    private String insertHistorySql;
    private int effectStartPosition;
    private int effectEndPosition;

    public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
        ResultSet rs = conn.getMetaData().getColumns(null, schemaName, tableName, null);
        StringBuilder insertSql = new StringBuilder(150);
        insertSql.append("insert into ").append(schemaName).append(".").append(tableName).append(HISTORY_SUFFIX).append(" (");
        int count = 0;
        while (rs.next()) {
            String columnName;
            if (++count > 1) {
                insertSql.append(",");
            }
            if ((columnName = rs.getString("COLUMN_NAME")).equalsIgnoreCase(SYS_PERIOD_START)) {
                this.effectStartPosition = count - 1;
            } else if (columnName.equalsIgnoreCase(SYS_PERIOD_END)) {
                this.effectEndPosition = count - 1;
            }
            insertSql.append(columnName);
        }
        insertSql.append(") values (");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                insertSql.append(",");
            }
            insertSql.append("?");
        }
        insertSql.append(");");
        this.insertHistorySql = insertSql.toString();
        log.debug("History table insert sql: {}", (Object)this.insertHistorySql);
    }

    public void fire(Connection connection, Object[] oldRow, Object[] newRow) throws SQLException {
        if (oldRow != null) {
            LocalDateTime now = LocalDateTime.now();
            oldRow[this.effectEndPosition] = now;
            if (newRow != null) {
                newRow[this.effectStartPosition] = now;
            }
            if (log.isTraceEnabled()) {
                log.trace("History insert: {}", (Object)Arrays.toString(oldRow));
            }
            this.insertIntoHistory(connection, oldRow);
        }
    }

    private void insertIntoHistory(Connection connection, Object[] oldRow) throws SQLException {
        try (PreparedStatement stmt = connection.prepareStatement(this.insertHistorySql);){
            for (int i = 0; i < oldRow.length; ++i) {
                stmt.setObject(i + 1, oldRow[i]);
            }
            stmt.executeUpdate();
        }
    }

    public void close() throws SQLException {
    }

    public void remove() throws SQLException {
    }
}

