/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.sqlserver;

import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;

final class SqlServerSqlLimiter
implements SqlLimiter {
    SqlServerSqlLimiter() {
    }

    public SqlLimitResponse limit(SqlLimitRequest request) {
        String dbSql = request.getDbSql();
        StringBuilder sb = new StringBuilder(50 + dbSql.length());
        int firstRow = request.getFirstRow();
        int maxRows = request.getMaxRows();
        if (firstRow < 1) {
            sb.append("select ");
            if (request.isDistinct()) {
                sb.append("distinct ");
            }
            sb.append("top ").append(maxRows).append(' ');
            sb.append(dbSql);
            return new SqlLimitResponse(sb.toString());
        }
        sb.append("select ");
        if (request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(dbSql);
        sb.append(' ').append("offset");
        sb.append(' ').append(firstRow).append(" rows");
        if (maxRows > 0) {
            sb.append(" fetch next ").append(maxRows).append(" rows only");
        }
        return new SqlLimitResponse(sb.toString());
    }
}

