/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.Commands;
import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.DbContainer;
import io.ebean.docker.container.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDbContainer
extends DbContainer
implements Container {
    protected static final Logger log = LoggerFactory.getLogger(Commands.class);

    BaseDbContainer(DbConfig config) {
        super(config);
    }

    protected abstract void createDbPreConnectivity();

    protected abstract void dropCreateDbPreConnectivity();

    protected void createDbPostConnectivity() {
    }

    protected void dropCreateDbPostConnectivity() {
    }

    @Override
    public boolean startWithCreate() {
        if (this.startIfNeeded() && this.fastStart()) {
            this.createDbPostConnectivity();
            return true;
        }
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.createDbPreConnectivity();
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        this.createDbPostConnectivity();
        return true;
    }

    @Override
    public boolean startWithDropCreate() {
        this.startIfNeeded();
        if (!this.waitForDatabaseReady()) {
            log.warn("Failed waitForDatabaseReady for container {}", (Object)this.config.containerName());
            return false;
        }
        this.dropCreateDbPreConnectivity();
        if (!this.waitForConnectivity()) {
            log.warn("Failed waiting for connectivity");
            return false;
        }
        this.dropCreateDbPostConnectivity();
        return true;
    }
}

