/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.convert.xml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import io.edurt.datacap.common.utils.DateUtils;
import io.edurt.datacap.convert.ConvertService;
import io.edurt.datacap.convert.FileConvert;
import io.edurt.datacap.convert.model.ConvertRequest;
import io.edurt.datacap.convert.model.ConvertResponse;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/edurt/datacap/convert/xml/XmlConvertService;", "Lio/edurt/datacap/convert/ConvertService;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "root", "", "node", "format", "Lio/edurt/datacap/convert/model/ConvertResponse;", "request", "Lio/edurt/datacap/convert/model/ConvertRequest;", "formatStream", "writer", "reader", "datacap-convert-xml"})
@SourceDebugExtension(value={"SMAP\nXmlConvertService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlConvertService.kt\nio/edurt/datacap/convert/xml/XmlConvertService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1863#2,2:153\n1863#2,2:155\n1863#2,2:157\n1863#2,2:159\n*S KotlinDebug\n*F\n+ 1 XmlConvertService.kt\nio/edurt/datacap/convert/xml/XmlConvertService\n*L\n36#1:153,2\n85#1:155,2\n131#1:157,2\n133#1:159,2\n*E\n"})
public final class XmlConvertService
implements ConvertService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final String root;
    @NotNull
    private final String node;

    public XmlConvertService() {
        this.root = "Root";
        this.node = "Node";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public ConvertResponse format(@NotNull ConvertRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ConvertResponse response = new ConvertResponse();
        try {
            this.log.info(this.name() + " format start time [ " + DateUtils.now() + " ]");
            response.setHeaders(request.getHeaders());
            XmlFactory factory = new XmlFactory();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Closeable closeable = (Closeable)factory.createGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                ToXmlGenerator generator = (ToXmlGenerator)closeable;
                boolean bl = false;
                generator.setCodec((ObjectCodec)new XmlMapper());
                XMLStreamWriter staxWriter = generator.getStaxWriter();
                staxWriter.writeStartElement(this.root);
                Iterable iterable = request.getColumns();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object column = element$iv = iterator.next();
                    boolean bl2 = false;
                    staxWriter.writeStartElement(this.node);
                    int n = ((Collection)request.getHeaders()).size();
                    for (int headerIndex = 0; headerIndex < n; ++headerIndex) {
                        if (!(column instanceof List)) {
                            throw new UnsupportedOperationException("Unsupported column type");
                        }
                        staxWriter.writeAttribute(request.getHeaders().get(headerIndex).toString(), String.valueOf(((List)column).get(headerIndex)));
                    }
                    staxWriter.writeEndElement();
                }
                staxWriter.writeEndElement();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String xmlString = outputStream.toString(Charsets.UTF_8);
            response.setColumns(CollectionsKt.listOf((Object)xmlString));
            this.log.info(this.name() + " format end time [ " + DateUtils.now() + " ]");
            response.setSuccessful(Boolean.valueOf(true));
        }
        catch (IOException e) {
            e.printStackTrace();
            response.setSuccessful(Boolean.valueOf(false));
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @NotNull
    public ConvertResponse formatStream(@NotNull ConvertRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public ConvertResponse writer(@NotNull ConvertRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ConvertResponse response = new ConvertResponse();
        try {
            this.log.info(this.name() + " writer start time [ " + DateUtils.now() + " ]");
            File file = FileConvert.formatFile((ConvertRequest)request, (String)this.name());
            this.log.info(this.name() + " writer file absolute path [ " + file.getAbsolutePath() + " ]");
            XmlFactory factory = new XmlFactory();
            Closeable closeable = (Closeable)factory.createGenerator(file, JsonEncoding.UTF8);
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                ToXmlGenerator generator = (ToXmlGenerator)closeable;
                boolean bl = false;
                generator.setCodec((ObjectCodec)new XmlMapper());
                XMLStreamWriter staxWriter = generator.getStaxWriter();
                staxWriter.writeStartElement(this.root);
                Iterable iterable = request.getColumns();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object column = element$iv = iterator.next();
                    boolean bl2 = false;
                    staxWriter.writeStartElement(this.node);
                    int n = ((Collection)request.getHeaders()).size();
                    for (int headerIndex = 0; headerIndex < n; ++headerIndex) {
                        if (!(column instanceof List)) {
                            throw new UnsupportedOperationException("Unsupported column type");
                        }
                        staxWriter.writeAttribute(request.getHeaders().get(headerIndex).toString(), String.valueOf(((List)column).get(headerIndex)));
                    }
                    staxWriter.writeEndElement();
                }
                staxWriter.writeEndElement();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.log.info(this.name() + " writer end time [ " + DateUtils.now() + " ]");
            response.setPath(file.getAbsolutePath());
            response.setSuccessful(Boolean.valueOf(true));
        }
        catch (IOException e) {
            response.setSuccessful(Boolean.valueOf(false));
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @NotNull
    public ConvertResponse reader(@NotNull ConvertRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ConvertResponse response = new ConvertResponse();
        try {
            this.log.info(this.name() + " reader start time [ " + DateUtils.now() + " ]");
            File file = FileConvert.formatFile((ConvertRequest)request, (String)this.name());
            this.log.info(this.name() + " reader file absolute path [ " + file.getAbsolutePath() + " ]");
            XmlMapper mapper = new XmlMapper();
            Object object = mapper.readValue(file, Map.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>>");
            Map rootNode = (Map)object;
            if (!rootNode.isEmpty() && rootNode.containsKey(this.node)) {
                List headers = new ArrayList();
                List columns = new ArrayList();
                List xmlElement = (List)rootNode.get(this.node);
                if (xmlElement != null) {
                    Object it;
                    Iterable $this$forEach$iv;
                    Iterable iterable = ((Map)xmlElement.get(0)).keySet();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (String)element$iv;
                        boolean bl = false;
                        headers.add(it);
                    }
                    $this$forEach$iv = xmlElement;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Map)element$iv;
                        boolean bl = false;
                        columns.add(it.values());
                    }
                } else {
                    throw new UnsupportedOperationException("Unsupported column type");
                }
                response.setHeaders(headers);
                response.setColumns(columns);
            }
            this.log.info(this.name() + " reader end time [ " + DateUtils.now() + " ]");
            response.setSuccessful(Boolean.valueOf(true));
        }
        catch (IOException e) {
            response.setSuccessful(Boolean.valueOf(false));
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @NotNull
    public String name() {
        return ConvertService.DefaultImpls.name((ConvertService)this);
    }

    @NotNull
    public String description() {
        return ConvertService.DefaultImpls.description((ConvertService)this);
    }
}

