/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.elasticsearch;

import io.edurt.datacap.plugin.jdbc.elasticsearch.ElasticSearchAdapter;
import io.edurt.datacap.plugin.jdbc.elasticsearch.ElasticSearchConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private ElasticSearchConnection connection;
    private Response response;

    public String name() {
        return "ElasticSearch";
    }

    public String description() {
        return "Integrate ElasticSearch data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("org.elasticsearch.xpack.sql.jdbc.EsDriver");
            this.jdbcConfigure.setJdbcType("es");
            this.connection = new ElasticSearchConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.connection))) {
            log.info("Execute elasticsearch plugin logic started");
            this.response = this.connection.getResponse();
            ElasticSearchAdapter processor = new ElasticSearchAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute elasticsearch plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.connection))) {
            this.connection.destroy();
        }
    }
}

