/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.mysql;

import io.edurt.datacap.plugin.jdbc.mysql.MySQLAdapter;
import io.edurt.datacap.plugin.jdbc.mysql.MySQLConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(MySQLPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private MySQLConnection mySQLConnection;
    private Response response;

    public String name() {
        return "MySQL";
    }

    public String description() {
        return "Integrate MySQL data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("com.mysql.jdbc.Driver");
            this.jdbcConfigure.setJdbcType("mysql");
            this.mySQLConnection = new MySQLConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.mySQLConnection))) {
            log.info("Execute mysql plugin logic started");
            this.response = this.mySQLConnection.getResponse();
            MySQLAdapter processor = new MySQLAdapter(this.mySQLConnection);
            this.response = processor.handlerExecute(content);
            log.info("Execute mysql plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.mySQLConnection))) {
            this.mySQLConnection.destroy();
        }
    }
}

