/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin.jdbc.sqlserver;

import io.edurt.datacap.plugin.jdbc.sqlserver.SqlServerAdapter;
import io.edurt.datacap.plugin.jdbc.sqlserver.SqlServerConnection;
import io.edurt.datacap.spi.Plugin;
import io.edurt.datacap.spi.PluginType;
import io.edurt.datacap.spi.connection.JdbcConfigure;
import io.edurt.datacap.spi.model.Configure;
import io.edurt.datacap.spi.model.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerPlugin
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(SqlServerPlugin.class);
    private JdbcConfigure jdbcConfigure;
    private SqlServerConnection connection;
    private Response response;

    public String name() {
        return "SqlServer";
    }

    public String description() {
        return "Integrate Microsoft SqlServer data sources";
    }

    public PluginType type() {
        return PluginType.JDBC;
    }

    public String validator() {
        return "SELECT @@VERSION";
    }

    public void connect(Configure configure) {
        try {
            this.response = new Response();
            this.jdbcConfigure = new JdbcConfigure();
            BeanUtils.copyProperties((Object)this.jdbcConfigure, (Object)configure);
            this.jdbcConfigure.setJdbcDriver("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.jdbcConfigure.setJdbcType("sqlserver");
            this.connection = new SqlServerConnection(this.jdbcConfigure, this.response);
        }
        catch (Exception ex) {
            this.response.setIsConnected(Boolean.FALSE);
            this.response.setMessage(ex.getMessage());
        }
    }

    public Response execute(String content) {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.connection))) {
            log.info("Execute sqlserver plugin logic started");
            this.response = this.connection.getResponse();
            SqlServerAdapter processor = new SqlServerAdapter(this.connection);
            this.response = processor.handlerExecute(content);
            log.info("Execute sqlserver plugin logic end");
        }
        return this.response;
    }

    public void destroy() {
        if (ObjectUtils.isNotEmpty((Object)((Object)this.connection))) {
            this.connection.destroy();
        }
    }
}

