/*
 * Decompiled with CFR 0.152.
 */
package io.edurt.datacap.plugin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.edurt.datacap.spi.PluginService;
import io.edurt.datacap.spi.model.Configure;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class SqlServerService
implements PluginService {
    private static final Logger log = LoggerFactory.getLogger(SqlServerService.class);

    public String validator() {
        return "SELECT @@VERSION";
    }

    public String driver() {
        return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    }

    public String connectType() {
        return "sqlserver";
    }

    public String url(Configure configure) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("jdbc:");
        buffer.append(configure.getType());
        buffer.append("://");
        buffer.append(configure.getHost());
        buffer.append(":");
        buffer.append(configure.getPort());
        buffer.append(";");
        if (configure.getDatabase().isPresent()) {
            buffer.append("databaseName=");
            buffer.append((String)configure.getDatabase().get());
            buffer.append(";");
        }
        if (configure.getSsl().isPresent()) {
            buffer.append(String.format("ssl=%s", configure.getSsl().get()));
            buffer.append(";");
            buffer.append("trustServerCertificate=true;");
        }
        if (configure.getEnv().isPresent()) {
            Map env = (Map)configure.getEnv().get();
            List flatEnv = env.entrySet().stream().map(value -> String.format("%s=%s", value.getKey(), value.getValue())).collect(Collectors.toList());
            buffer.append(String.join((CharSequence)";", flatEnv));
        }
        return buffer.toString();
    }
}

