package io.embrace.android.embracesdk;

import android.app.Activity;
import android.app.Application;
import androidx.lifecycle.LifecycleObserver;
import android.content.ComponentCallbacks2;

import io.embrace.android.embracesdk.utils.optional.Optional;

import java.io.Closeable;

/**
 * Service which handles Android activity lifecycle callbacks.
 */
interface ActivityService
        extends
        ComponentCallbacks2,
        LifecycleObserver,
        Application.ActivityLifecycleCallbacks,
        Closeable {
    /**
     * Whether the application is in the background.
     *
     * @return true if the application is in the background, false otherwise
     */
    boolean isInBackground();

    /**
     * Gets the activity which is currently in the foreground.
     *
     * @return an optional of the activity currently in the foreground
     */
    Optional<Activity> getForegroundActivity();

    /**
     * Adds an observer of the application's lifecycle activity events.
     *
     * @param listener the observer to register
     * @param priority true if this listener should execute before all others
     */
    void addListener(ActivityListener listener, boolean priority);

    /**
     * Adds an observer of the application's lifecycle activity events.
     *
     * @param listener the observer to register
     */
    void addListener(ActivityListener listener);

    /**
     * Removes an observer of the application's lifecycle activity events.
     *
     * @param listener the listener to remove
     */
    void removeListener(ActivityListener listener);
}
