package io.embrace.android.embracesdk;

import static io.embrace.android.embracesdk.config.AnrConfig.*;

import androidx.annotation.Nullable;

import java.util.Map;

import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.config.AnrConfig;

class AnrConfigKeyValueReader extends KeyValueReader<AnrConfig> {

    protected AnrConfigKeyValueReader(InternalEmbraceLogger logger) {
        super(logger);
    }

    @Nullable
    @Override
    AnrConfig transform(@Nullable Map<String, String> data) {
        if (data == null) {
            return null;
        }
        return new AnrConfig(
                longFromString(data.get(ANR_CFG_TIMESTAMP)),
                intFromString(data.get(PCT_ENABLED)),
                intFromString(data.get(PCT_BG_ENABLED)),
                longFromString(data.get(INTERVAL)),
                intFromString(data.get(PER_INTERVAL)),
                intFromString(data.get(MAX_DEPTH)),
                intFromString(data.get(PER_SESSION)),
                booleanFromString(data.get(MAIN_THREAD_ONLY)),
                booleanFromString(data.get(ALLOW_EARLY_CAPTURE)),
                intFromString(data.get(PRIORITY)),
                intFromString(data.get(MIN_DURATION)),
                readStringCollection(data.get(WHITE_LIST)),
                readStringCollection(data.get(BLACK_LIST))
        );
    }
}
