package io.embrace.android.embracesdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.HashMap;
import java.util.Map;

import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.config.AnrConfig;

class AnrConfigKeyValueWriter extends KeyValueWriter<AnrConfig> {

    private final Clock clock;

    AnrConfigKeyValueWriter(@NonNull Clock clock, @NonNull InternalEmbraceLogger logger) {
        super(logger);
        this.clock = clock;
    }

    @Nullable
    @Override
    Map<String, String> transform(@NonNull AnrConfig data) {
        Map<String, String> props = new HashMap<>();
        props.put(AnrConfig.ANR_CFG_TIMESTAMP, String.valueOf(clock.now()));
        props.put(AnrConfig.PCT_ENABLED, String.valueOf(data.getPctEnabled()));
        props.put(AnrConfig.PCT_BG_ENABLED, String.valueOf(data.getPctBgEnabled()));
        props.put(AnrConfig.INTERVAL, String.valueOf(data.getIntervalMs()));
        props.put(AnrConfig.PER_INTERVAL, String.valueOf(data.getStacktracesPerInterval()));
        props.put(AnrConfig.MAX_DEPTH, String.valueOf(data.getStacktraceMaxLength()));
        props.put(AnrConfig.PER_SESSION, String.valueOf(data.getMaxAnrCapturedIntervalsPerSession()));
        props.put(AnrConfig.MAIN_THREAD_ONLY, String.valueOf(data.isMainThreadOnly()));
        props.put(AnrConfig.ALLOW_EARLY_CAPTURE, String.valueOf(data.isAllowEarlyCapture()));
        props.put(AnrConfig.PRIORITY, String.valueOf(data.getPriority()));
        props.put(AnrConfig.MIN_DURATION, String.valueOf(data.getMinDuration()));

        // add the sanitized string collections
        String allow = serializeStringCollection(data.getAllowList());
        props.put(AnrConfig.WHITE_LIST, allow);

        String block = serializeStringCollection(data.getBlockList());
        props.put(AnrConfig.BLACK_LIST, block);
        return props;
    }
}
