package io.embrace.android.embracesdk

import com.google.gson.annotations.SerializedName

/**
 * A measurement of the device's battery level at a given point in time.
 */
internal data class BatteryMeasurement(
    /** The timestamp at which the battery measurement event occurred.  */
    @SerializedName("ts") val timestamp: Long,
    /** The power level of the device at the time the battery measurement event occurred.  */
    @SerializedName("v") val value: Float
)
