package io.embrace.android.embracesdk;

import java.io.IOException;

import io.embrace.android.embracesdk.utils.Supplier;

/**
 * A simple implementation of ConfigService which simply returns default values.
 * <p>
 * This is only intended for use by the {@link AnrService} at present - beware as this
 * may return false/null values for everything that isn't used in the ANR service.
 */
class EarlyDefaultConfigService implements ConfigService {

    private final Supplier<Config> supplier;

    EarlyDefaultConfigService(Supplier<Config> supplier) {
        this.supplier = supplier;
    }

    @Override
    public Config getConfig() {
        return supplier.get();
    }

    @Override
    public boolean isAnrCaptureEnabled() {
        return getConfig().captureEarlyAnrs();
    }

    @Override
    public boolean isBgAnrCaptureEnabled() {
        return getConfig().captureEarlyAnrs();
    }

    @Override
    public boolean isGoogleAnrCaptureEnabled() {
        return false;
    }

    /*** Below methods are stubbed and disabled in the unlikely case they are used. ***/

    @Override
    public boolean isUnityNdkSamplingEnabled() {
        return false;
    }

    @Override
    public boolean isScreenshotDisabledForEvent(String eventName) {
        return true;
    }

    @Override
    public boolean isEventDisabled(String eventName) {
        return true;
    }

    @Override
    public boolean isLogMessageDisabled(String logMessage) {
        return true;
    }

    @Override
    public boolean isMessageTypeDisabled(MessageType type) {
        return true;
    }

    @Override
    public boolean isUrlDisabled(String url) {
        return true;
    }

    @Override
    public boolean isSdkDisabled() {
        return false;
    }

    @Override
    public void addListener(ConfigListener configListener) {

    }

    @Override
    public void removeListener(ConfigListener configListener) {
       
    }

    @Override
    public boolean isSessionControlEnabled() {
        return false;
    }

    @Override
    public boolean isInternalExceptionCaptureEnabled() {
        return false;
    }

    @Override
    public boolean isBetaFeaturesEnabled() {
        return false;
    }

    @Override
    public boolean isSigHandlerDetectionEnabled() {
        return false;
    }

    @Override
    public void close() throws IOException {
       
    }
}
