package io.embrace.android.embracesdk;

import android.content.Context;

import java.util.Random;

import io.embrace.android.embracesdk.config.AnrConfig;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;

class EmbraceEarlyAnrInitializer {

    private final EmbraceAnrService service;
    private volatile Config config = Config.ofDefault();

    EmbraceEarlyAnrInitializer(Context context) {
        InternalEmbraceLogger logger = InternalStaticEmbraceLogger.getLogger();
        CacheService cacheService = new EmbraceCacheService(context, logger);
        EarlyDefaultConfigService configService = new EarlyDefaultConfigService(() -> config);
        Clock intervalClock = new NormalizedIntervalClock(new SystemClock());
        GoogleAnrTimestampRepository googleAnrTimestampRepository = new GoogleAnrTimestampRepository(logger);
        FilesDelegate filesDelegate = new FilesDelegate();
        service = new EmbraceAnrService(intervalClock, configService, logger,
                new SharedObjectLoader(),
                new FindGoogleThread(logger,
                        new GetThreadsInCurrentProcess(filesDelegate),
                        new GetThreadCommand(filesDelegate)),
                new GoogleAnrHandlerNativeDelegate(googleAnrTimestampRepository, logger),
                googleAnrTimestampRepository);

        // read the ANR config on a background thread then start ANR capture if needed.
        service.monitorService.submit(() -> {
            try {
                startAnrCaptureIfNeeded(cacheService);
                logger.logInfo("Initialized early capture of ANRs.");
            } catch (Throwable exc) {
                logger.logWarning("Failed to load ANR config for early capture." +
                        " Falling back to regular ANR initialization.", exc);
            }
        });
    }

    private void startAnrCaptureIfNeeded(CacheService cacheService) {
        AnrConfig anrConfig = cacheService.loadAnrConfig(() -> 0);

        if (anrConfig != null) {
            config = Config.ofDefault(anrConfig, null, new Random());

            if (config.captureEarlyAnrs()) {
                service.startAnrCapture();
            }
        }
    }

    public EmbraceAnrService getService() {
        return service;
    }
}
