package io.embrace.android.embracesdk;

import androidx.annotation.VisibleForTesting;

import java.util.concurrent.CopyOnWriteArrayList;

import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;

final class EmbraceMemoryCleanerService implements MemoryCleanerService {

    private static final String ERROR_FAILED_TO_CLEAN = "Failed to clean collections on service listener";

    /**
     * List of listeners that subscribe to clean services collections.
     */
    @VisibleForTesting
    final CopyOnWriteArrayList<MemoryCleanerListener> listeners = new CopyOnWriteArrayList<>();

    @Override
    public void cleanServicesCollections(MetadataService metadataService, EmbraceExceptionService exceptionService) {
        InternalStaticEmbraceLogger.logDeveloper("EmbraceMemoryCleanerService", "Clean services collections");
        StreamUtilsKt.stream(listeners, listener -> {
            try {
                listener.cleanCollections();
            } catch (Exception ex) {
                InternalStaticEmbraceLogger.logDebug(ERROR_FAILED_TO_CLEAN, ex);
            }
            return null;
        });
        metadataService.setActiveSessionId(null);
        exceptionService.resetExceptionErrorObject();
    }

    @Override
    public void addListener(MemoryCleanerListener listener) {
        listeners.addIfAbsent(listener);
    }
}
