package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.config.GatingConfig.Companion.LOG_PROPERTIES
import io.embrace.android.embracesdk.config.GatingConfig.Companion.SESSION_PROPERTIES
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger

internal class EventSanitizer(
    private val event: Event,
    private val enabledComponents: Set<String>
) : Sanitizable<Event> {

    override fun sanitize(): Event {
        InternalStaticEmbraceLogger.logger.logDeveloper("EventSanitizer", "sanitize")
        val builder = Event.newBuilder(event)

        InternalStaticEmbraceLogger.logger.logDeveloper("EventSanitizer", "isLogEvent: " + isLogEvent())
        if (isLogEvent()) {
            if (!shouldSendLogProperties()) {
                InternalStaticEmbraceLogger.logger.logDeveloper("EventSanitizer", "not shouldSendLogProperties")
                builder.withCustomProperties(null)
            }
        }

        if (!shouldSendSessionProperties()) {
            InternalStaticEmbraceLogger.logger.logDeveloper("EventSanitizer", "not shouldSendSessionProperties")
            builder.withSessionProperties(null)
        }

        return builder.build()
    }

    private fun isLogEvent() =
        event.type == EmbraceEvent.Type.ERROR_LOG ||
            event.type == EmbraceEvent.Type.WARNING_LOG ||
            event.type == EmbraceEvent.Type.INFO_LOG

    private fun shouldSendLogProperties() =
        enabledComponents.contains(LOG_PROPERTIES)

    private fun shouldSendSessionProperties() =
        enabledComponents.contains(SESSION_PROPERTIES)
}
