package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger

internal class EventSanitizerFacade(
    private val eventMessage: EventMessage,
    private val components: Set<String>
) {

    fun getSanitizedMessage(): EventMessage {
        InternalStaticEmbraceLogger.logger.logDeveloper("EventSanitizerFacade", "getSanitizedMessage")
        val sanitizedEvent = EventSanitizer(eventMessage.event, components).sanitize()
        val sanitizedUserInfo = UserInfoSanitizer(eventMessage.userInfo, components).sanitize()
        val sanitizedPerformanceInfo =
            PerformanceInfoSanitizer(eventMessage.performanceInfo, components).sanitize()

        return EventMessage.newBuilder(eventMessage)
            .withEvent(sanitizedEvent)
            .withUserInfo(sanitizedUserInfo)
            .withPerformanceInfo(sanitizedPerformanceInfo)
            .build()
    }
}
