package io.embrace.android.embracesdk;

import androidx.annotation.VisibleForTesting;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Describes a particular Exception error. Where an exception error has a cause, there will be an
 * {@link ExceptionErrorInfo} for each nested cause.
 */
final class ExceptionErrorInfo {
    /**
     * Timestamp when exception error happened.
     */
    @SerializedName("ts")
    @VisibleForTesting
    final Long timestamp;

    /**
     * App state (foreground or background).
     */
    @SerializedName("s")
    @VisibleForTesting
    final String state;

    /**
     * A list of exceptions.
     */
    @SerializedName("ex")
    @VisibleForTesting
    final List<ExceptionInfo> exceptions;

    public ExceptionErrorInfo(Long timestamp, String state, List<ExceptionInfo> exceptions) {
        this.timestamp = timestamp;
        this.state = state;
        this.exceptions = exceptions;
    }
}
