package io.embrace.android.embracesdk

import android.app.ActivityManager
import android.app.ActivityManager.RunningAppProcessInfo
import android.app.ActivityManager.RunningAppProcessInfo.IMPORTANCE_VISIBLE

internal class ForegroundDetector {

    /**
     * Determines whether or not the process is in the foreground, via the importance flag.
     * If the importance is <= [RunningAppProcessInfo.IMPORTANCE_FOREGROUND_SERVICE] then
     * we consider the process to be in the foreground.
     *
     * Generally this internal API should be avoided in favour of registering for lifecycle
     * callbacks, but it is useful for populating initial values (e.g. for Unity).
     */
    @JvmOverloads
    fun isInForeground(info: RunningAppProcessInfo = RunningAppProcessInfo()) = runCatching {
        ActivityManager.getMyMemoryState(info)
        info.importance <= IMPORTANCE_VISIBLE
    }.getOrDefault(false)
}
