package io.embrace.android.embracesdk;

import android.content.Context;

import io.embrace.android.embracesdk.utils.optional.Optional;

interface MetadataService {
    /**
     * Gets information about the current application being instrumented. This is sent with the
     * following events, as well as all sessions:
     * <ul>
     * <li>START</li>
     * <li>INFO_LOG</li>
     * <li>ERROR_LOG</li>
     * <li>WARNING_LOG</li>
     * <li>CRASH</li>
     * </ul>
     *
     * @return the application information
     */
    AppInfo getAppInfo();

    /**
     * Same as {@link #getAppInfo()} but does not search for information (in preferences, for example) that is
     * not already loaded in memory in the service.
     */
    AppInfo getLightweightAppInfo();

    /**
     * Whether or not this is a debug build of the application.
     *
     * @return true if the build is a debug build, otherwise false
     */
    boolean isDebug();

    /**
     * Gets the app ID which is defined as part of the configuration.
     *
     * @return the app ID.
     */
    String getAppId();

    /**
     * Gets information and specifications of the current device. This is sent with the following
     * events, as well as all sessions:
     * <ul>
     * <li>START</li>
     * <li>INFO_LOG</li>
     * <li>ERROR_LOG</li>
     * <li>WARNING_LOG</li>
     * <li>CRASH</li>
     * </ul>
     *
     * @return the device information
     */
    DeviceInfo getDeviceInfo();

    /**
     * Same as {@link #getDeviceInfo()} but does not get storage information from the file system.
     */
    DeviceInfo getLightweightDeviceInfo();

    /**
     * Gets the current device's disk usage and space available.
     *
     * @return the device's disk usage statistics
     */
    DiskUsage getDiskUsage();

    /**
     * Gets the device's screen resolution.
     *
     * @return the device's screen resolution
     */
    String getScreenResolution();

    /**
     * Gets if the device is jailbroken.
     *
     * @return if the device is Jailbroken
     */
    Boolean getIsJailbroken();

    /**
     * Gets the unique ID from the device. This is an MD5 hash of the Android Secure ID.
     *
     * @return the unique device ID
     */
    String getDeviceId();

    /**
     * @return the app version code.
     */
    String getAppVersionCode();

    /**
     * @return the app version name.
     */
    String getAppVersionName();

    /**
     * @return is the app was updated since last launch.
     */
    boolean isAppUpdated();

    /**
     * @return is the OS was updated since last launch.
     */
    boolean isOsUpdated();

    /**
     * Gets the currently active session ID, if present.
     *
     * @return an optional containing the currently active session ID
     */
    Optional<String> getActiveSessionId();

    /**
     * Sets the currently active session ID;
     *
     * @param sessionId the session ID that is currently active
     */
    void setActiveSessionId(String sessionId);

    /**
     * Returns 'active' if the application is in the foreground, or 'background' if the app is in
     * the background.
     *
     * @return the current state of the app
     */
    String getAppState();

    /**
     * Sets React Native Bundle ID from a custom JavaScript Bundle URL.
     */
    void setReactNativeBundleId(Context context, String jsBundleIdUrl);
}
