package io.embrace.android.embracesdk;

import com.google.gson.annotations.SerializedName;

import java.util.List;
import java.util.Map;

class NativeCrashData {

    @SerializedName("report_id")
    private final String id;

    @SerializedName("sid")
    private final String sessionId;

    @SerializedName("ts")
    private final Long timestamp;

    @SerializedName("state")
    private final String appState;

    @SerializedName("meta")
    private final NativeCrashMetadata metadata;

    @SerializedName("crash")
    private final String crash;

    @SerializedName("symbols")
    private Map<String, String> symbols;

    @SerializedName("errors")
    private List<Error> errors;

    @SerializedName("map")
    private String map;

    public NativeCrashData(String id, String sessionId, Long timestamp, String appState, NativeCrashMetadata metadata,
                           String crash, Map<String, String> symbols, List<Error> errors, String map) {
        this.id = id;
        this.sessionId = sessionId;
        this.timestamp = timestamp;
        this.appState = appState;
        this.metadata = metadata;
        this.crash = crash;
        this.symbols = symbols;
        this.errors = errors;
        this.map = map;
    }

    public void setSymbols(Map<String, String> symbols) {
        this.symbols = symbols;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public void setMap(String map) {
        this.map = map;
    }
    public String getNativeCrashId() {
        return id;
    }

    public String getSessionId() {
        return sessionId;
    }

    public Long getTimestamp() {
        return timestamp;
    }

    public String getAppState() {
        return appState;
    }

    public NativeCrashMetadata getMetadata() {
        return metadata;
    }

    public NativeCrash getCrash() {
        return new NativeCrash(id, crash, symbols, errors, map);
    }

    public Map<String, String> getSymbols() {
        return symbols;
    }

    public List<Error> getErrors() { return errors; }

    public String getMap() { return map; }

    public static class NativeCrashMetadata {

        @SerializedName("a")
        private final AppInfo appInfo;

        @SerializedName("d")
        private final DeviceInfo deviceInfo;

        @SerializedName("u")
        private final UserInfo userInfo;

        @SerializedName("sp")
        private final Map<String, String> sessionProperties;

        NativeCrashMetadata(AppInfo appInfo, DeviceInfo deviceInfo, UserInfo userInfo, Map<String, String> sessionProperties) {
            this.appInfo = appInfo;
            this.deviceInfo = deviceInfo;
            this.userInfo = userInfo;
            this.sessionProperties = sessionProperties;
        }

        public DeviceInfo getDeviceInfo() {
            return deviceInfo;
        }

        public AppInfo getAppInfo() {
            return appInfo;
        }

        public UserInfo getUserInfo() {
            return userInfo;
        }

        public Map<String, String> getSessionProperties() {
            return sessionProperties;
        }

        public String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{\"a\":");
            sb.append(appInfo.toJson());
            sb.append(",\"d\":");
            sb.append(deviceInfo.toJson());
            sb.append(",\"u\":");
            sb.append(userInfo.toJson());
            sb.append(",\"sp\":");
            sb.append(MessageUtils.withMap(sessionProperties));
            sb.append("}");
            return sb.toString();
        }
    }

    public static class Error {

        @SerializedName("n")
        private final int number;

        @SerializedName("c")
        private final int context;

        Error(int number, int context) {
            this.number = number;
            this.context = context;
        }

        public int getNumber() {
            return number;
        }

        public int getContext() {
            return context;
        }
    }
}
