package io.embrace.android.embracesdk

import com.google.gson.annotations.SerializedName

/**
 * Holds data for a sample of a native stacktrace.
 */
internal data class NativeStackframeSample(

    /**
     * The program counter
     */
    @SerializedName("pc")
    internal val pc: String?,

    /**
     * The link register
     */
    @SerializedName("lr")
    internal val lr: String?,

    /**
     * The stack pointer
     */
    @SerializedName("sp")
    internal val sp: String?,

    /**
     * The dex program counter
     */
    @SerializedName("dx")
    internal val dx: String?,

    /**
     * The hex address of the symbol in the shared object. This information may not be available
     * in which case the value will be 0x0.
     */
    @SerializedName("s")
    internal val soSymbolAddr: String?,

    /**
     * The hex load address of shared object. This information may not be available
     * in which case the value will be 0x0.
     */
    @SerializedName("l")
    internal val soLoadAddr: String?,

    /**
     * The absolute path of the shared object. This information may not be available
     * in which case the string will be null.
     */
    @SerializedName("p")
    internal val soPath: String?,

    /**
     * The result for unwinding this particular stackframe. Non-zero values indicate an error.
     */
    @SerializedName("r")
    internal val result: Int?,

    /**
     * The last address that the signal handler attempted to read before encountering an error
     */
    @SerializedName("ea")
    internal val lastErrorAddress: String?,

    /**
     * The error code encountered by the signal handler for this frame
     */
    @SerializedName("ec")
    internal val lastErrorCode: Int?,
)
