package io.embrace.android.embracesdk

import com.google.gson.annotations.SerializedName

/**
 * Holds data for a sample of a native stackframe.
 */
internal class NativeStacktraceSample(

    /**
     * A zero value indicates the sample was successful. A non-zero value indicates
     * that something went wrong with the sample. Error codes match those defined in utilities.h.
     *
     * Depending on the error code, the stack might not be populated if the error condition is
     * likely to increase the payload size.
     */
    @SerializedName("r")
    val result: Int?,

    /**
     * The return code set by the unwinder. For libunwindstack this is always zero. For libunwind,
     * this is the reason code returned by calling _Unwind_Backtrace (typically _URC_END_OF_STACK
     * or _URC_NO_REASON).
     */
    @SerializedName("c")
    val unwindReasonCode: Int?,

    /**
     * How long unwinding took in milliseconds. This does not include
     * the overall duration of the JNI call.
     */
    @SerializedName("u")
    val unwindDurationMs: Long?,

    /**
     * Whether the word size is 32 bit or not.
     */
    @SerializedName("b")
    val is32Bit: Boolean?,

    /**
     * The CPU ABI of the device. ARM32=1, ARM64=2
     */
    @SerializedName("a")
    val arch: Int?,

    /**
     * All the stackframes which have been captured during the current sample.
     */
    @SerializedName("s")
    var stack: List<NativeStackframeSample>?
) {

    /**
     * The time in milliseconds since the thread was first detected as blocked
     */
    @SerializedName("t")
    internal var sampleTimestamp: Long? = null

    /**
     * How long unwinding took in milliseconds, including
     * the overall duration of the JNI call.
     */
    @SerializedName("d")
    internal var sampleDurationMs: Long? = null
}
