package io.embrace.android.embracesdk;

/**
 * A clock which uses {@link android.os.SystemClock#elapsedRealtime()} that is normalized
 * to the first {@link System#currentTimeMillis()} value.
 *
 * This is useful when it is necessary to perform interval timing but the results must be
 * sent to the API in a way that matches the device time.
 */
final class NormalizedIntervalClock implements Clock {

    private final long baseline;

    NormalizedIntervalClock(SystemClock systemClock) {
        baseline = systemClock.now() - android.os.SystemClock.elapsedRealtime();
    }

    @Override
    public long now() {
        return baseline + android.os.SystemClock.elapsedRealtime();
    }
}
