package io.embrace.android.embracesdk;

import android.content.res.Configuration;

import androidx.annotation.VisibleForTesting;

import com.google.gson.annotations.SerializedName;

final class Orientation {

    @SerializedName("o")
    @VisibleForTesting
    String orientation;

    @SerializedName("ts")
    @VisibleForTesting
    Long timestamp;

    Orientation(int orientation, Long timestamp) {
        this.orientation = orientation == Configuration.ORIENTATION_LANDSCAPE ? "l" : "p";
        this.timestamp = timestamp;
    }

    int getInternalOrientation() {
        return orientation.equals("l") ? Configuration.ORIENTATION_LANDSCAPE : Configuration.ORIENTATION_PORTRAIT;
    }
}
