package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.utils.optional.Optional;

import java.io.Closeable;
import java.util.List;

/**
 * Provides access to information about the device's battery and power state.
 */
interface PowerService extends Closeable {
    /**
     * Gets a list representing the periods during which the battery on the device was charging.
     *
     * @param startTime the time to search from
     * @param endTime the time to search up until
     * @return the list of intervals during which the device was charging
     */
    List<Interval> getChargingIntervals(long startTime, long endTime);

    /**
     * Gets a list of battery measurements which have been captured periodically from the device
     * showing the current battery level.
     *
     * @param startTime the time to search from
     * @param endTime the time to search up until
     * @return the list of battery measurements
     */
    List<BatteryMeasurement> getBatteryMeasurements(long startTime, long endTime);

    /**
     * Gets the latest battery level measurement.
     *
     * @return the battery level, if a measurement has been taken
     */
    Optional<Float> getLatestBatteryLevel();
}
