package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.config.GatingConfig.Companion.PERFORMANCE_NETWORK
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger

internal class SessionPerformanceInfoSanitizer(
    private val sessionPerformanceInfo: SessionPerformanceInfo?,
    private val enabledComponents: Set<String>
) :
    Sanitizable<SessionPerformanceInfo> {

    override fun sanitize(): SessionPerformanceInfo? {
        InternalStaticEmbraceLogger.logger.logDeveloper(
            "SessionPerformanceInfoSanitizer",
            "sanitize"
        )
        return sessionPerformanceInfo?.let {
            // sanitizes performance info
            val sanitizedPerformanceInfoBuilder = SessionPerformanceInfo.fromPerformanceInfo(
                PerformanceInfoSanitizer(sessionPerformanceInfo, enabledComponents).sanitize()
            )

            // sanitizes session performance info
            InternalStaticEmbraceLogger.logger.logDeveloper(
                "SessionPerformanceInfoSanitizer",
                "shouldSendCapturedNetwork: " + shouldSendCapturedNetwork()
            )
            if (shouldSendCapturedNetwork()) {
                sanitizedPerformanceInfoBuilder.withNetworkRequests(sessionPerformanceInfo.networkRequests)
            } else {
                sanitizedPerformanceInfoBuilder.withNetworkRequests(null)
            }

            return sanitizedPerformanceInfoBuilder.build()
        }
    }

    private fun shouldSendCapturedNetwork() =
        enabledComponents.contains(PERFORMANCE_NETWORK)
}
