package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.config.GatingConfig.Companion.LOGS_INFO
import io.embrace.android.embracesdk.config.GatingConfig.Companion.LOGS_WARN
import io.embrace.android.embracesdk.config.GatingConfig.Companion.SESSION_MOMENTS
import io.embrace.android.embracesdk.config.GatingConfig.Companion.SESSION_ORIENTATIONS
import io.embrace.android.embracesdk.config.GatingConfig.Companion.SESSION_PROPERTIES
import io.embrace.android.embracesdk.config.GatingConfig.Companion.SESSION_USER_TERMINATION
import io.embrace.android.embracesdk.config.GatingConfig.Companion.STARTUP_MOMENT
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger.Companion.logger

internal class SessionSanitizer(
    private val session: Session,
    private val enabledComponents: Set<String>
) : Sanitizable<Session> {

    override fun sanitize(): Session {
        logger.logDeveloper("SessionSanitizer", "sanitize")
        val builder = Session.newBuilder(session)

        if (!shouldSendSessionProperties()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendSessionProperties")
            builder.withProperties(null)
        }

        if (!shouldSendTrackedOrientations()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendTrackedOrientations")
            builder.withOrientations(null)
        }

        if (!shouldSendUserTerminations()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendUserTerminations")
            builder.withTerminationTime(null)
            builder.withReceivedTermination(null)
        }

        if (!shouldSendInfoLog()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendInfoLog")
            builder.withInfoLogIds(null)
            builder.withInfoLogsAttemptedToSend(null)
        }

        if (!shouldSendWarnLog()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendWarnLog")
            builder.withWarningLogIds(null)
            builder.withWarnLogsAttemptedToSend(null)
        }
        if (!shouldSendMoment()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendMoment")
            builder.withEventIds(null)
        }

        if (!shouldSendStartupMoment()) {
            logger.logDeveloper("SessionSanitizer", "not shouldSendStartupMoment")
            builder.withStartupDuration(null)
            builder.withStartupStacktraces(null)
            builder.withStartupThreshold(null)
        }

        // always disable beta features if the gating config has been enabled
        builder.disableBetaFeatures()

        logger.logDeveloper("SessionSanitizer", "builder.build()")
        return builder.build()
    }

    private fun shouldSendSessionProperties() =
        enabledComponents.contains(SESSION_PROPERTIES)

    private fun shouldSendTrackedOrientations() =
        enabledComponents.contains(SESSION_ORIENTATIONS)

    private fun shouldSendUserTerminations() =
        enabledComponents.contains(SESSION_USER_TERMINATION)

    private fun shouldSendMoment() =
        enabledComponents.contains(SESSION_MOMENTS)

    private fun shouldSendInfoLog() =
        enabledComponents.contains(LOGS_INFO)

    private fun shouldSendWarnLog() =
        enabledComponents.contains(LOGS_WARN)

    private fun shouldSendStartupMoment() =
        enabledComponents.contains(STARTUP_MOMENT)
}
