package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger

internal class SessionSanitizerFacade(
    private val sessionMessage: SessionMessage,
    private val components: Set<String>
) {

    fun getSanitizedMessage(): SessionMessage {
        InternalStaticEmbraceLogger.logger.logDeveloper("SessionSanitizerFacade", "getSanitizedMessage")
        val sanitizedSession = SessionSanitizer(sessionMessage.session, components).sanitize()
        val sanitizedUserInfo = UserInfoSanitizer(sessionMessage.userInfo, components).sanitize()
        val sanitizedPerformanceInfo =
            SessionPerformanceInfoSanitizer(sessionMessage.performanceInfo, components).sanitize()
        val sanitizedBreadcrumbs = BreadcrumbsSanitizer(sessionMessage.breadcrumbs, components).sanitize()

        return SessionMessage.newBuilder(sessionMessage)
            .withSession(sanitizedSession)
            .withUserInfo(sanitizedUserInfo)
            .withPerformanceInfo(sanitizedPerformanceInfo)
            .withBreadcrumbs(sanitizedBreadcrumbs)
            .build()
    }
}
