package io.embrace.android.embracesdk

/**
 * Listener interface for the session start message.
 */
internal fun interface SessionStartListener {

    /**
     * When this method is invoked you can alter the session start message as required.
     */
    fun onSessionStart(builder: Session.Builder)
}

/**
 * Listener interface for the session end message.
 */
internal fun interface SessionEndListener {

    /**
     * When this method is invoked you can alter the session end message as required.
     */
    fun onSessionEnd(builder: Session.Builder)
}
