package io.embrace.android.embracesdk;

import androidx.annotation.VisibleForTesting;

import com.google.gson.annotations.SerializedName;

import java.util.List;

final class Stacktraces {

    @SerializedName("tt")
    @VisibleForTesting
    final List<String> stacktraces;

    @SerializedName("jsk")
    private final String javascriptStacktrace;

    @SerializedName("u")
    @VisibleForTesting
    final String unityStacktrace;

    Stacktraces(List<String> stacktraces, String customStacktrace, Embrace.AppFramework framework) {
        if (framework == Embrace.AppFramework.REACT_NATIVE) {
            this.javascriptStacktrace = customStacktrace;
            this.unityStacktrace = null;
        } else if (framework == Embrace.AppFramework.UNITY) {
            this.unityStacktrace = customStacktrace;
            this.javascriptStacktrace = null;
        } else {
            this.unityStacktrace = null;
            this.javascriptStacktrace = null;
        }
        this.stacktraces = customStacktrace != null ? null : stacktraces;
    }
}
