package io.embrace.android.embracesdk;

import static io.embrace.android.embracesdk.Config.StartupSamplingConfig.PCT_ENABLED;
import static io.embrace.android.embracesdk.Config.StartupSamplingConfig.SAMPLE_GRANULARITY;
import static io.embrace.android.embracesdk.Config.StartupSamplingConfig.SAMPLE_INTERVAL;
import static io.embrace.android.embracesdk.Config.StartupSamplingConfig.SAMPLING_DURATION;
import static io.embrace.android.embracesdk.Config.StartupSamplingConfig.STACKTRACE_LENGTH;

import androidx.annotation.Nullable;

import java.util.Map;

import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;

class StartupSamplingConfigKeyValueReader extends KeyValueReader<Config.StartupSamplingConfig> {

    protected StartupSamplingConfigKeyValueReader(InternalEmbraceLogger logger) {
        super(logger);
    }

    @Nullable
    @Override
    Config.StartupSamplingConfig transform(@Nullable Map<String, String> data) {
        if (data == null) {
            return null;
        }
        return new Config.StartupSamplingConfig(
                intFromString(data.get(PCT_ENABLED)),
                intFromString(data.get(SAMPLE_INTERVAL)),
                intFromString(data.get(SAMPLE_GRANULARITY)),
                intFromString(data.get(SAMPLING_DURATION)),
                intFromString(data.get(STACKTRACE_LENGTH))
        );
    }
}
