package io.embrace.android.embracesdk;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.HashMap;
import java.util.Map;

import io.embrace.android.embracesdk.Config.StartupSamplingConfig;
import io.embrace.android.embracesdk.logging.InternalEmbraceLogger;

class StartupSamplingConfigKeyValueWriter extends KeyValueWriter<StartupSamplingConfig> {

    private final Clock clock;

    StartupSamplingConfigKeyValueWriter(@NonNull Clock clock, @NonNull InternalEmbraceLogger logger) {
        super(logger);
        this.clock = clock;
    }

    @Nullable
    @Override
    Map<String, String> transform(@NonNull StartupSamplingConfig data) {
        Map<String, String> props = new HashMap<>();
        props.put(StartupSamplingConfig.PCT_ENABLED, String.valueOf(data.getPctEnabled()));
        props.put(StartupSamplingConfig.SAMPLE_GRANULARITY, String.valueOf(data.getSampleGranularity()));
        props.put(StartupSamplingConfig.SAMPLE_INTERVAL, String.valueOf(data.getSampleInterval()));
        props.put(StartupSamplingConfig.SAMPLING_DURATION, String.valueOf(data.getSamplingDuration()));
        props.put(StartupSamplingConfig.STACKTRACE_LENGTH, String.valueOf(data.getMaxStacktraceLength()));

        return props;
    }
}
