package io.embrace.android.embracesdk;

import androidx.annotation.Nullable;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.List;

@InternalApi
public class StartupStacktrace {
    /**
     * Absolute timestamp of the sample
     */
    @SerializedName("ts")
    private final long timestamp;

    @SerializedName("o")
    private final long offset;

    /**
     * String representation of each line of the stack trace.
     */
    @SerializedName("tt")
    private List<String> lines;

    StartupStacktrace(long timestamp, long offset, List<String> lines) {
        this.timestamp = timestamp;
        this.offset = offset;
        this.lines = new ArrayList<>(lines);
    }

    /**
     * Remove the lines from this stacktrace if the other stacktrace has the same lines. This will
     * reduce the size of the session payload when multiple stacktraces are sent.
     *
     * @param other stacktrace being compared to
     * @return boolean if the lines were cleared
     */
    public boolean clearLinesIfTheyMatch(@Nullable StartupStacktrace other) {
        if (other == null || other.lines == null || lines == null || !lines.equals(other.getLines())) {
            return false;
        }
        lines = null;
        return true;
    }

    List<String> getLines() {
        return lines;
    }
}
