package io.embrace.android.embracesdk

import io.embrace.android.embracesdk.config.GatingConfig.Companion.USER_PERSONAS
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger

internal class UserInfoSanitizer(
    private val userInfo: UserInfo?,
    private val enabledComponents: Set<String>
) : Sanitizable<UserInfo> {

    override fun sanitize(): UserInfo {
        val builder = UserInfo.newBuilder(userInfo)

        if (!shouldSendUserPersonas()) {
            InternalStaticEmbraceLogger.logger.logDeveloper("UserInfoSanitizer", "not shouldSendUserPersonas")
            builder.withPersonas(null)
        }

        InternalStaticEmbraceLogger.logger.logDeveloper("UserInfoSanitizer", "sanitize - userInfo: " + userInfo?.userId)
        return builder.build()
    }

    private fun shouldSendUserPersonas() =
        enabledComponents.contains(USER_PERSONAS)
}
