package io.embrace.android.embracesdk;

import java.util.UUID;

@InternalApi
public final class Uuid {

    private Uuid() {
    }

    /**
     * Get the Embrace UUID based on a random UUID.
     *
     * @return the Embrace UUID.
     */
    public static String getEmbUuid() {
        return getEmbUuid(null);
    }

    /**
     * Get the Embrace UUID. If the argument uuid is null, generates the Embrace UUID using a
     * random UUID.
     *
     * @param uuid the uuid.
     * @return the Embrace UUID.
     */
    public static String getEmbUuid(String uuid) {
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
        }

        // optimization: avoid expensive pattern compilation in replaceAll()
        char[] buf = uuid.toCharArray();
        StringBuilder sb = new StringBuilder();

        for (char c : buf) {
            if (c != '-') {
                switch (c) {
                    case ' ':
                        sb.append('0');
                        break;
                    case 'a':
                        sb.append('A');
                        break;
                    case 'b':
                        sb.append('B');
                        break;
                    case 'c':
                        sb.append('C');
                        break;
                    case 'd':
                        sb.append('D');
                        break;
                    case 'e':
                        sb.append('E');
                        break;
                    case 'f':
                        sb.append('F');
                        break;
                    default:
                        sb.append(c);
                        break;
                }
            }
        }
        return sb.toString();
    }
}
