package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.utils.optional.Optional;
import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents the display event for a View.
 */
final class ViewBreadcrumb implements Breadcrumb {

    private static final String FALLBACK_SCREEN_NAME = "Unknown screen";

    /**
     * The screen name for the view breadcrumb.
     */
    @SerializedName("vn")
    private final String screen;

    /**
     * The timestamp at which the view started.
     */
    @SerializedName("st")
    private final Long start;

    /**
     * The timestamp at which the view ended.
     */
    @SerializedName("en")
    private Long end;

    ViewBreadcrumb(String screen, long start) {
        this.start = start;
        this.end = null;
        this.screen = screen != null ? screen : FALLBACK_SCREEN_NAME;
    }

    Optional<String> getScreen() {
        return Optional.of(screen);
    }

    public long getStart() { return start; }

    public long getEnd() { return end; }

    public void setEnd(Long end) { this.end = end; }

    @Override
    public long getStartTime() {
        return start;
    }
}
