package io.embrace.android.embracesdk;

import android.util.Pair;

import io.embrace.android.embracesdk.TapBreadcrumb.TapBreadcrumbType;

@InternalApi
public final class ViewSwazzledHooks {

    private static final String UNKNOWN_ELEMENT_NAME = "Unknown element";

    static void logOnClickEvent(android.view.View view, TapBreadcrumbType breadcrumbType) {
        String viewName = "";
        try {
            viewName = view.getResources().getResourceName(view.getId());
        } catch (Exception e) {
            viewName = UNKNOWN_ELEMENT_NAME;
        }
        Pair point = null;
        try {
            point = new Pair<>(view.getX(), view.getY());
        } catch (Exception e) {
            point = new Pair<>(0.0F, 0.0F);
        }
        Embrace.getInstance().logTap(point, viewName, breadcrumbType);
    }

    @InternalApi
    public static final class OnClickListener {
        public static void _preOnClick(android.view.View.OnClickListener thiz, android.view.View view) {
            logOnClickEvent(view, TapBreadcrumbType.TAP);
        }
    }

    @InternalApi
    public static final class OnLongClickListener {
        public static void _preOnLongClick(android.view.View.OnLongClickListener thiz, android.view.View view) {
            logOnClickEvent(view, TapBreadcrumbType.LONG_PRESS);
        }
    }
}
