package io.embrace.android.embracesdk;

import io.embrace.android.embracesdk.utils.optional.Optional;
import com.google.gson.annotations.SerializedName;

/**
 * Breadcrumb that represents the onPageStarted event for a WebView.
 */
class WebViewBreadcrumb implements Breadcrumb {

    @SerializedName("u")
    private final String url;

    @SerializedName("st")
    private final long startTime;


    WebViewBreadcrumb(String url, long timestamp) {
        this.url = url;
        this.startTime = timestamp;
    }

    Optional<String> getUrl() {
        return Optional.of(url);
    }

    @Override
    public long getStartTime() {
        return startTime;
    }
}
