package io.embrace.android.embracesdk;

import android.os.Process;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;

final class WorkerUtils {
    static ThreadFactory createThreadFactory(String name) {
        return runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable::run);
            thread.setName("Embrace Background Worker " + name);
            return thread;
        };
    }

    static void shutdownHook(final ExecutorService service, String name) {
        Runtime.getRuntime().addShutdownHook(new Thread(new PriorityRunnable() {
            public void runWithPriority() {
                try {
                    InternalStaticEmbraceLogger.logDebug("Shutdown hook for executor called");
                    service.shutdown();
                    if (!service.awaitTermination(4, TimeUnit.SECONDS)) {
                        InternalStaticEmbraceLogger.logDebug("Executor did not shut down in time, shutting down immediately");
                        service.shutdownNow();
                    }
                } catch (InterruptedException ex) {
                    InternalStaticEmbraceLogger.logDebug("Interrupted whilst attempting to shut down.");
                    service.shutdownNow();
                    Thread.currentThread().interrupt();
                }

            }
        }, "Embrace Shutdown Hook for Worker: " + name));
    }

    private abstract static class PriorityRunnable implements Runnable {
        PriorityRunnable() {
        }

        @Override
        public void run() {
            Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND);
        }

        abstract void runWithPriority();
    }

    private WorkerUtils() {
        // Restricted constructor
    }
}
