package io.embrace.android.embracesdk.config

import com.google.gson.annotations.SerializedName

/**
 * This contains config values which can turn risky functionality completely off.
 * In normal circumstances these should never actually be used 🤞.
 */
internal data class KillSwitchConfig @JvmOverloads constructor(
    @SerializedName(SIG_HANDLER_DETECTION)
    private val sigHandlerDetection: Boolean? = null
) {

    /**
     * Whether we should attempt to detect when other code overwrites the signal handlers
     * our SDK installs.
     */
    fun isSigHandlerDetectionEnabled(): Boolean = sigHandlerDetection ?: DEFAULT_SIG_HANDLER_DETECTION

    companion object {
        const val DEFAULT_SIG_HANDLER_DETECTION = true
        const val SIG_HANDLER_DETECTION = "sig_handler_detection"
    }
}
