package io.embrace.android.embracesdk.logging

import android.util.Log
import io.embrace.android.embracesdk.EmbraceLogger

private const val EMBRACE_TAG = "[Embrace]"
private const val DEVELOPER_EMBRACE_TAG = "[EmbraceDev]"

internal class AndroidLogger : InternalEmbraceLogger.LoggerAction {
    override fun log(msg: String, severity: EmbraceLogger.Severity, throwable: Throwable?, logStacktrace: Boolean) {
        val exception = throwable?.takeIf { logStacktrace }
        when (severity) {
            EmbraceLogger.Severity.DEBUG -> Log.d(EMBRACE_TAG, msg, exception)
            EmbraceLogger.Severity.INFO -> Log.i(EMBRACE_TAG, msg, exception)
            EmbraceLogger.Severity.WARNING -> Log.w(EMBRACE_TAG, msg, exception)
            EmbraceLogger.Severity.DEVELOPER -> Log.d(DEVELOPER_EMBRACE_TAG, msg, exception)
            else -> Log.e(EMBRACE_TAG, msg, exception)
        }
    }
}
