package io.embrace.android.embracesdk.logging

import android.util.Log
import io.embrace.android.embracesdk.EmbraceLogger.Severity

/**
 * Wrapper for the Android [Log] utility.
 * Can only be used internally, it's not part of the public API.
 */

internal class InternalStaticEmbraceLogger {

    companion object : InternalEmbraceLogger.LoggerAction {

        @JvmStatic
        val logger = InternalEmbraceLogger().apply {
            addLoggerAction(AndroidLogger())
        }

        @JvmStatic
        @JvmOverloads
        fun logDeveloper(className: String, msg: String, throwable: Throwable? = null) {
            log("[$className] $msg", Severity.DEVELOPER, throwable, true)
        }

        @JvmStatic
        @JvmOverloads
        fun logDebug(msg: String, throwable: Throwable? = null) {
            log(msg, Severity.DEBUG, throwable, true)
        }

        @JvmStatic
        fun logInfo(msg: String) {
            log(msg, Severity.INFO, null, true)
        }

        @JvmStatic
        @JvmOverloads
        fun logWarning(msg: String, throwable: Throwable? = null) {
            log(msg, Severity.WARNING, throwable, true)
        }

        @JvmStatic
        @JvmOverloads
        fun logError(msg: String, throwable: Throwable? = null, logStacktrace: Boolean = false) {
            log(msg, Severity.ERROR, throwable, logStacktrace)
        }

        /**
         * Logs a message.
         *
         * @param msg the message to log.
         * @param severity how severe the log is. If it's lower than the threshold, the message will not be logged.
         * @param throwable exception, if any.
         * @param logStacktrace should add the throwable to the logging
         */

        @JvmStatic
        override fun log(msg: String, severity: Severity, throwable: Throwable?, logStacktrace: Boolean) =
            logger.log(msg, severity, throwable, logStacktrace)

        @JvmStatic
        fun setThreshold(severity: Severity) = logger.setThreshold(severity)
    }
}
