package io.embrace.android.embracesdk.networking;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.List;
import java.util.Map;

import javax.net.ssl.SSLSocketFactory;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import io.embrace.android.embracesdk.InternalApi;

@InternalApi
public interface EmbraceConnection {

    boolean isHttps();

    void setRequestMethod(@NonNull String method) throws ProtocolException;
    void setDoOutput(@NonNull Boolean doOutput);
    void setConnectTimeout(@NonNull Integer timeout);
    void setReadTimeout(@NonNull Integer readTimeout);
    void setRequestProperty(@NonNull String key, @Nullable String value);

    @NonNull
    EmbraceUrl getURL();

    @Nullable
    String getRequestMethod();
    @Nullable
    String getHeaderField(@NonNull String key);
    @Nullable
    Map<String, List<String>> getHeaderFields();

    @Nullable
    OutputStream getOutputStream() throws IOException;
    @Nullable
    InputStream getInputStream() throws IOException;
    @Nullable
    InputStream getErrorStream();

    void connect() throws IOException;

    int getResponseCode() throws IOException;
    @Nullable
    String getResponseMessage() throws IOException;

    void setSSLSocketFactory(@Nullable SSLSocketFactory factory);
    @Nullable
    SSLSocketFactory getSSLSocketFactory();
}
